﻿@{
    # User Reg Paths
    items = @(
        @{
            Path = 'Software\Policies\Microsoft\'
            Name = 'Internet Explorer'
        }
        @{
            Path = 'Software\Policies\Microsoft\Internet Explorer'
            Name = 'Main'
        }
        @{
            Path = 'Software\Microsoft'
            Name = 'BluetoothAuthenticationAgent'
        }
    )

    # User Registry Entries
    entries = @(
        @{
		    Key       = 'Software\Microsoft\Windows\CurrentVersion\WinTrust\Trust Providers\Software Publishing'
		    ValueName = 'State'
		    ValueData = '146432'
		    ValueType = 'DWORD'
	    },
	    @{
		    Key       = 'Software\Policies\Microsoft\Internet Explorer\Main'
		    ValueName = 'Use FormSuggest'
		    ValueData = 'no'
		    ValueType = 'string'
	    }
        @{
		    Key       = 'Control Panel\Desktop'
		    ValueName = 'AutoEndTasks'
		    ValueData = '1'
		    ValueType = 'String'
	    }
        @{
		    Key       = 'Software\Microsoft\BluetoothAuthenticationAgent'
		    ValueName = 'AcceptIncomingRequests'
		    ValueData = '1'
		    ValueType = 'String'
	    }
    )

    # Local User Reg Paths
    localUserItems = @(
        @{
            Path = 'Software\Microsoft\Windows\CurrentVersion\'
            Name = 'Policies'
        }
        @{
            Path = 'Software\Microsoft\Windows\CurrentVersion\Policies'
            Name = 'Attachments'
        }
        @{
            Path = 'Software\Microsoft\Windows\CurrentVersion\Policies'
            Name = 'System'
        }
        @{
            Path = 'Software\Policies\Microsoft\Windows\CurrentVersion'
            Name = 'PushNotifications'
        }
        @{
            Path = 'Software\Policies\Microsoft\Windows'
            Name = 'CloudContent'
        }
        @{
            Path = 'Software\Policies\Microsoft\Windows'
            Name = 'WindowsCopilot'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\excel'
            Name = 'options'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\excel\options'
            Name = 'binaryoptions'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\excel'
            Name = 'internet'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\excel\security'
            Name = 'fileblock'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\excel\security'
            Name = 'protectedview'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\excel\security'
            Name = 'external content'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\excel\security'
            Name = 'filevalidation'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\excel\security'
            Name = 'trusted locations'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\ms project\security'
            Name = 'trusted locations'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\visio\security'
            Name = 'fileblock'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\visio\security'
            Name = 'trusted locations'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0'
            Name = 'outlook'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\outlook'
            Name = 'security'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\outlook'
            Name = 'options'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\outlook\options'
            Name = 'general'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\outlook\options'
            Name = 'mail'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\outlook'
            Name = 'rpc'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\word\security'
            Name = 'fileblock'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\word\security'
            Name = 'filevalidation'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\word\security'
            Name = 'protectedview'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\word\security'
            Name = 'trusted locations'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\powerpoint\security'
            Name = 'fileblock'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\powerpoint\security'
            Name = 'filevalidation'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\powerpoint\security'
            Name = 'protectedview'
        }
        @{
            Path = 'Software\Policies\Microsoft\Office\16.0\powerpoint\security'
            Name = 'trusted locations'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0'
            Name = 'Common'
        }
        @{
            Path = 'Software\policies\Microsoft\Office'
            Name = 'Common'
        }
        @{
            Path = 'Software\policies\Microsoft'
            Name = 'VBA'
        }
        @{
            Path = 'Software\policies\Microsoft\VBA'
            Name = 'Security'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\Common'
            Name = 'security'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common'
            Name = 'toolbars'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common\toolbars'
            Name = 'Word'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common\toolbars'
            Name = 'Access'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common\toolbars'
            Name = 'Excel'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common\toolbars'
            Name = 'InfoPath'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common\toolbars'
            Name = 'PowerPoint'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common\toolbars'
            Name = 'Outlook'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common\toolbars'
            Name = 'Publisher'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common\toolbars'
            Name = 'Project'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common\toolbars'
            Name = 'Visio'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common'
            Name = 'security'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common\security'
            Name = 'trusted locations'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common'
            Name = 'trustcenter'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\Common'
            Name = 'smart tag'
        }
        @{
            Path = 'Software\policies\Microsoft\Office\16.0\Common'
            Name = 'portal'
        }
        @{
			Path = 'Software\policies\Microsoft\Office\16.0\Common'
			Name = 'privacy'
		}
		@{
			Path = 'Software\policies\Microsoft\Office\Common'
			Name = 'clienttelemetry'
        }
    )

    # Local User Registry Entries
    localUserEntries = @(
        #IE 11 STIG
        @{
		    Key       = 'Software\Policies\Microsoft\Internet Explorer\Main'
		    ValueName = 'FormSuggest Passwords'
		    ValueData = 'no'
		    ValueType = 'string'
	    },
        @{
		    Key       = 'Software\Policies\Microsoft\Internet Explorer\Main'
		    ValueName = 'FormSuggest PW Ask'
		    ValueData = 'no'
		    ValueType = 'String'
	    },

        # Windows 11 STIG
        @{
		    Key       = 'Software\Microsoft\Windows\CurrentVersion\Policies\Attachments'
		    ValueName = 'SaveZoneInformation'
		    ValueData = '2'
		    ValueType = 'DWORD'
	    },
        @{
		    Key       = 'Software\Policies\Microsoft\Windows\CurrentVersion\PushNotifications'
		    ValueName = 'NoToastApplicationNotificationOnLockScreen'
		    ValueData = '1'
		    ValueType = 'DWORD'
	    },
        @{
		    Key       = 'Software\Policies\Microsoft\Windows\CloudContent'
		    ValueName = 'DisableThirdPartySuggestions'
		    ValueData = '1'
		    ValueType = 'DWORD'
	    },
        @{
		    Key       = 'SOFTWARE\Policies\Microsoft\Windows\WindowsCopilot'
		    ValueName = 'TurnOffWindowsCopilot'
		    ValueData = '1'
		    ValueType = 'DWORD'
	    },

        # M365 STIG: Access
        @{
		    Key       = 'software\policies\microsoft\office\16.0\access\security'
		    ValueName = 'blockcontentexecutionfrominternet'
		    ValueData = '1'
		    ValueType = 'DWORD'
	    },
        @{
		    Key       = 'software\policies\microsoft\office\16.0\access\security'
		    ValueName = 'notbpromptunsignedaddin'
		    ValueData = '1'
		    ValueType = 'DWORD'
	    },
        @{
		    Key       = 'software\policies\microsoft\office\16.0\access\security'
		    ValueName = 'requireaddinsig'
		    ValueData = '1'
		    ValueType = 'DWORD'
	    },
        @{
		    Key       = 'software\policies\microsoft\office\16.0\access\security'
		    ValueName = 'vbawarnings'
		    ValueData = '3'
		    ValueType = 'DWORD'
	    },

        # M365 STIG: Excel
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\filevalidation'
            ValueName = 'disableeditfrompv'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
		    Key       = 'software\policies\microsoft\office\16.0\excel\options'
		    ValueName = 'extractdatadisableui'
		    ValueData = '1'
		    ValueType = 'DWORD'
	    },
        @{
            Key       = 'software\policies\microsoft\office\16.0\excel\security'
            ValueName = 'extensionhardening'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\excel\security'
            ValueName = 'excelbypassencryptedmacroscan'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\excel\security\filevalidation'
            ValueName = 'enableonload'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\excel\security'
            ValueName = 'webservicefunctionwarnings'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\excel\security'
            ValueName = 'blockcontentexecutionfrominternet'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\excel\security'
            ValueName = 'notbpromptunsignedaddin'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\excel\security'
            ValueName = 'requireaddinsig'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\excel\security'
            ValueName = 'vbawarnings'
            ValueType = 'DWORD'
            ValueData = '3'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\excel\security\external content'
            ValueName = 'enableblockunsecurequeryfiles'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\excel\security\external content'
            ValueName = 'disableddeserverlaunch'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\excel\security\external content'
            ValueName = 'disableddeserverlookup'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'dbasefiles'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'difandsylkfiles'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'htmlandxmlssfiles'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'openinprotectedview'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'xl2macros'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'xl2worksheets'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'xl3macros'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'xl3worksheets'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'xl4macros'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'xl4workbooks'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'xl4worksheets'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'xl9597workbooksandtemplates'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\fileblock'
            ValueName = 'xl95workbooks'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\protectedview'
            ValueName = 'disableattachmentsinpv'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\protectedview'
            ValueName = 'disableinternetfilesinpv'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\protectedview'
            ValueName = 'disableunsafelocationsinpv'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\protectedview'
            ValueName = 'enabledatabasefileprotectedview'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\security\trusted locations'
            ValueName = 'allownetworklocations'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\options'
            ValueName = 'disableautorepublish'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\options'
            ValueName = 'disableautorepublishwarning'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\options\binaryoptions'
            ValueName = 'fupdateext_78_1'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\excel\internet'
            ValueName = 'donotloadpictures'
            ValueType = 'DWORD'
            ValueData = '1'
        },

        # M365 Office
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\toolbars\Word'
            ValueName = 'noextensibilitycustomizationfromdocument'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\toolbars\Access'
            ValueName = 'noextensibilitycustomizationfromdocument'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\toolbars\Excel'
            ValueName = 'noextensibilitycustomizationfromdocument'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\toolbars\InfoPath'
            ValueName = 'noextensibilitycustomizationfromdocument'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\toolbars\PowerPoint'
            ValueName = 'noextensibilitycustomizationfromdocument'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\toolbars\Outlook'
            ValueName = 'noextensibilitycustomizationfromdocument'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\toolbars\Publisher'
            ValueName = 'noextensibilitycustomizationfromdocument'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\toolbars\Project'
            ValueName = 'noextensibilitycustomizationfromdocument'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\toolbars\Visio'
            ValueName = 'noextensibilitycustomizationfromdocument'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\common\security'
            ValueName = 'uficontrols'
            ValueType = 'DWORD'
            ValueData = '6'
        },
        @{
            Key       = 'software\policies\microsoft\office\common\security'
            ValueName = 'automationsecurity'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\trustcenter'
            ValueName = 'trustbar'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\security'
            ValueName = 'defaultencryption12'
            ValueType = 'String'
            ValueData = 'Microsoft Enhanced RSA and AES Cryptographic Provider,AES 256,256'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\security'
            ValueName = 'openxmlencryption'
            ValueType = 'String'
            ValueData = 'Microsoft Enhanced RSA and AES Cryptographic Provider,AES 256,256'
        },
        @{
            Key       = 'software\policies\microsoft\vba\security'
            ValueName = 'loadcontrolsinforms'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\security'
            ValueName = 'macroruntimescanscope'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\security'
            ValueName = 'drmencryptproperty'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\security\trusted locations'
            ValueName = 'allow user locations'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\portal'
            ValueName = 'linkpublishingDisabled'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\common\smart tag'
            ValueName = 'neverloadmanifests'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\common\clienttelemetry'
            ValueName = 'sendtelemetry'
            ValueType = 'DWORD'
            ValueData = '3'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\privacy'
            ValueName = 'controllerconnectedservicesenabled'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\privacy'
            ValueName = 'disconnectedstate'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\privacy'
            ValueName = 'Usercontentdisabled'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\common\privacy'
            ValueName = 'downloadcontentdisabled'
            ValueType = 'DWORD'
            ValueData = '2'
        },

        # M365 Outlook
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'adminsecuritymode'
            ValueType = 'DWORD'
            ValueData = '3'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'sharedfolderscript'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'promptoomsaveas'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'allowuserstolowerattachments'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'publicfolderscript'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\Outlook\options\mail'
            ValueName = 'internet'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'allowactivexoneoffforms'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'promptoomsend'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'enableoneoffformscripts'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\Outlook'
            ValueName = 'disallowattachmentcustomization'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'Level'
            ValueType = 'DWORD'
            ValueData = '3'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'usecrlchasing'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'promptoomformulaaccess'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'warnaboutinvalid'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'authenticationservice'
            ValueType = 'DWORD'
            ValueData = '16'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\Outlook\options\mail'
            ValueName = 'junkmailprotection'
            ValueType = 'DWORD'
            ValueData = '6'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'promptoomaddressinformationaccess'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\rpc'
            ValueName = 'enablerpcencryption'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'showlevel1attach'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\options\general'
            ValueName = 'msgformat'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\options\mail'
            ValueName = 'junkmailenablelinks'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'promptoomcustomaction'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'promptoomaddressbookaccess'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'promptoommeetingtaskrequestresponse'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'minenckey'
            ValueType = 'DWORD'
            ValueData = '168'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'publishtogaldisabled'
            ValueType = 'DWORD'
            ValueData = '1'
        },

        # M365 PowerPoint
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\powerpoint\security'
            ValueName = 'runprograms'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\powerpoint\security'
            ValueName = 'powerpointbypassencryptedmacroscan'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\powerpoint\security\filevalidation'
            ValueName = 'enableonload'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\powerpoint\security'
            ValueName = 'blockcontentexecutionfrominternet'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\powerpoint\security'
            ValueName = 'notbpromptunsignedaddin'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\powerpoint\security'
            ValueName = 'requireaddinsig'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\powerpoint\security'
            ValueName = 'vbawarnings'
            ValueType = 'DWORD'
            ValueData = '3'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\powerpoint\security\fileblock'
            ValueName = 'binaryfiles'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\powerpoint\security\fileblock'
            ValueName = 'openinprotectedview'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\powerpoint\security\protectedview'
            ValueName = 'disableattachmentsinpv'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\powerpoint\security\protectedview'
            ValueName = 'disableinternetfilesinpv'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\powerpoint\security\protectedview'
            ValueName = 'disableunsafelocationsinpv'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\powerpoint\security\filevalidation'
            ValueName = 'disableeditfrompv'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\powerpoint\security\filevalidation'
            ValueName = 'enableonload'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\powerpoint\security\filevalidation'
            ValueName = 'openinprotectedview'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\powerpoint\security\trusted locations'
            ValueName = 'allownetworklocations'
            ValueType = 'DWORD'
            ValueData = '0'
        },

        # M365 Project
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\ms project\security\trusted locations'
            ValueName = 'allownetworklocations'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\ms project\security'
            ValueName = 'notbpromptunsignedaddin'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\ms project\security'
            ValueName = 'requireaddinsig'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\ms project\security'
            ValueName = 'vbawarnings'
            ValueType = 'DWORD'
            ValueData = '3'
        },

        # M365 Publisher
        @{
            Key       = 'software\policies\microsoft\office\common\security'
            ValueName = 'automationsecuritypublisher'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\publisher\security'
            ValueName = 'notbpromptunsignedaddin'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\publisher\security'
            ValueName = 'requireaddinsig'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\publisher\security'
            ValueName = 'vbawarnings'
            ValueType = 'DWORD'
            ValueData = '3'
        },

        # M365 Visio
        @{
            Key       = 'software\policies\microsoft\office\16.0\visio\security\trusted locations'
            ValueName = 'allownetworklocations'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\visio\security'
            ValueName = 'blockcontentexecutionfrominternet'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\visio\security'
            ValueName = 'notbpromptunsignedaddin'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\visio\security'
            ValueName = 'requireaddinsig'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\visio\security'
            ValueName = 'vbawarnings'
            ValueType = 'DWORD'
            ValueData = '3'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\visio\security\fileblock'
            ValueName = 'visio2000files'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\visio\security\fileblock'
            ValueName = 'visio2003files'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\visio\security\fileblock'
            ValueName = 'visio50andearlierfiles'
            ValueType = 'DWORD'
            ValueData = '2'
        },

        # M365 Word
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\filevalidation'
            ValueName = 'enableonload'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\word\security'
            ValueName = 'blockcontentexecutionfrominternet'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\word\security'
            ValueName = 'notbpromptunsignedaddin'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\word\security'
            ValueName = 'requireaddinsig'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\word\security'
            ValueName = 'vbawarnings'
            ValueType = 'DWORD'
            ValueData = '3'
        },
        @{
            Key       = 'software\policies\microsoft\office\16.0\word\security'
            ValueName = 'wordbypassencryptedmacroscan'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\filevalidation'
            ValueName = 'disableeditfrompv'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\filevalidation'
            ValueName = 'openinprotectedview'
            ValueType = 'DWORD'
            ValueData = '1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\trusted locations'
            ValueName = 'allownetworklocations'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\protectedview'
            ValueName = 'disableattachmentsinpv'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\protectedview'
            ValueName = 'disableinternetfilesinpv'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\protectedview'
            ValueName = 'disableunsafelocationsinpv'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\fileblock'
            ValueName = 'openinprotectedview'
            ValueType = 'DWORD'
            ValueData = '0'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\fileblock'
            ValueName = 'word2000files'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\fileblock'
            ValueName = 'word2003files'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\fileblock'
            ValueName = 'word2007files'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\fileblock'
            ValueName = 'word2files'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\fileblock'
            ValueName = 'word60files'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\fileblock'
            ValueName = 'word95files'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\fileblock'
            ValueName = 'word97files'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\fileblock'
            ValueName = 'wordxmlfiles'
            ValueType = 'DWORD'
            ValueData = '2'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\word\security\fileblock'
            ValueName = 'wordxpfiles'
            ValueType = 'DWORD'
            ValueData = '2'
        }

        # Desktop Wallpaper
        @{
		    Key       = 'Software\Microsoft\Windows\CurrentVersion\Policies\System'
		    ValueName = 'Wallpaper'
		    ValueData = 'C:\Windows\Web\Wallpaper\Def_Wall3.jpg'
		    ValueType = 'String'
	    }
        @{
		    Key       = 'Software\Microsoft\Windows\CurrentVersion\Policies\System'
		    ValueName = 'WallpaperStyle'
		    ValueData = '4'
		    ValueType = 'String'
	    }
    )

    removes = @(
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'fileextensionsremovelevel1'
        },
        @{
            Key       = 'software\Policies\Microsoft\office\16.0\outlook\security'
            ValueName = 'fileextensionsremovelevel2'
        }
    )
}
